<?php

function akismet_save_comment($x){

	include akismet_lib_path . 'akismet.class.php'; 

	$comment = $x['comment'];

	$user = new User;
	$user->id = $comment->author;
	$user->read();

	$story['author'] = $user->username;
	$story['email'] = $user->email;
	$story['body'] = $comment->content;
	$story['user_ip'] = $user->extra_field['user_lastip'];

	$akismet = new Akismet(my_base_url . my_pligg_base, get_misc_data('wordpress_key'), $story); 

	if($akismet->errorsExist()) { // returns true if any errors exist 
		if($akismet->isError('AKISMET_INVALID_KEY')) { 
			 echo 'invalid key';
		} elseif($akismet->isError('AKISMET_RESPONSE_FAILED')) { 
			 echo 'response failed';
		} elseif($akismet->isError('AKISMET_SERVER_NOT_FOUND')) { 
			 echo 'server not found';
		} 
	} else { // No errors, check for spam 
		if ($akismet->isSpam()){
			$x['comment']->canSave = false;
		} else {
			$x['comment']->canSave = true;
		}
	}
}


function akismet_check_submit(&$vars){

	include akismet_lib_path . 'akismet.class.php'; 

	$x = $vars['linkres'];
  
	$user = new User;
	$user->id = $x->author;
	$user->read();

	$story['author'] = $user->username;
	$story['email'] = $user->email;
	$story['website'] = $x->url;
	$story['body'] = $x->content;
	$story['permalink'] = getmyurl('story', $x->id);
	$story['user_ip'] = $user->extra_field['user_lastip'];

	$akismet = new Akismet(my_base_url . my_pligg_base, get_misc_data('wordpress_key'), $story); 

	// test for errors 

	if($akismet->errorsExist()) { // returns true if any errors exist 
		if($akismet->isError('AKISMET_INVALID_KEY')) { 
			// echo 'invalid key';
		} elseif($akismet->isError('AKISMET_RESPONSE_FAILED')) { 
			// echo 'response failed';
		} elseif($akismet->isError('AKISMET_SERVER_NOT_FOUND')) { 
			// echo 'server not found';
		} 
	} else { // No errors, check for spam 
		if ($akismet->isSpam()) { // returns true if Akismet thinks the comment is spam 


			$spam_links = get_misc_data('spam_links');
			if($spam_links != ''){
				$spam_links = unserialize(get_misc_data('spam_links'));
			} else {
				$spam_links = array();
			}
			$spam_links[] = $x->id;

			misc_data_update('spam_links', serialize($spam_links));


		} else { 
			// echo 'not spam';
		} 
	} 

}

function akismet_top(){

	global $main_smarty, $the_template, $current_user, $db;

	//force_authentication();
	$canIhaveAccess = 0;
	$canIhaveAccess = $canIhaveAccess + checklevel('god');

	if($canIhaveAccess == 1)
	{

		$spam_links = get_misc_data('spam_links');
		if($spam_links != ''){
			$spam_links = unserialize(get_misc_data('spam_links'));
		} else {
			$spam_links = array();
		}

		$main_smarty->assign('menu_spam', count($spam_links));

	}
}

function akismet_showpage(){

	global $main_smarty, $the_template, $current_user, $db;


	force_authentication();
	$canIhaveAccess = 0;
	$canIhaveAccess = $canIhaveAccess + checklevel('god');

	if($canIhaveAccess == 1)
	{

		$navwhere['text1'] = 'Akismet';
		$navwhere['link1'] = URL_akismet;

		define('pagename', 'akismet'); 
		$main_smarty->assign('pagename', pagename);

		if(isset($_REQUEST['view'])){$view = sanitize($_REQUEST['view'], 3);}else{$view='';}

		if($view == ''){
			$wordpress_key = get_misc_data('wordpress_key');
			if($wordpress_key == ''){header('Location: ' . URL_akismet . '&view=manageKey');}

			$spam_links = get_misc_data('spam_links');
			if($spam_links != ''){
				$spam_links = unserialize(get_misc_data('spam_links'));
			} else {
				$spam_links = array();
			}

			$main_smarty->assign('spam_links', $spam_links);
			$main_smarty->assign('spam_links_count', count($spam_links));

			$main_smarty = do_sidebar($main_smarty, $navwhere);
			$main_smarty->assign('posttitle', " / " . $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel'));

			$main_smarty->assign('tpl_center', akismet_tpl_path . 'main');
			$main_smarty->display($the_template . '/pligg.tpl');
		}

		if($view == 'manageKey'){
			$wordpress_key = get_misc_data('wordpress_key');
			$main_smarty->assign('wordpress_key', $wordpress_key);

			$main_smarty = do_sidebar($main_smarty, $navwhere);
			$main_smarty->assign('posttitle', " / " . $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel'));

			$main_smarty->assign('tpl_center', akismet_tpl_path . 'manageKey');
			$main_smarty->display($the_template . '/pligg.tpl');
		}

		if($view == 'updateKey'){
			if(isset($_REQUEST['key'])){$wordpress_key = sanitize($_REQUEST['key'], 3);}else{$wordpress_key='';}
			misc_data_update('wordpress_key', $wordpress_key);
			header('Location: ' . URL_akismet);
		}

		if($view == 'manageSpam'){

			$spam_links = get_misc_data('spam_links');
			if($spam_links != ''){
				$spam_links = unserialize(get_misc_data('spam_links'));
			} else {
				$spam_links = array();
			}

			if(count($spam_links) > 0){
				$sql = "SELECT " . table_links . ".* FROM " . table_links . " WHERE "; 
				$sql .= 'link_id IN ('.implode(',',$spam_links).')';
				$link_data = $db->get_results($sql);
				$main_smarty->assign('link_data', object_2_array($link_data));
			} else {

				header('Location: ' . URL_akismet);

				// $main_smarty->assign('link_data', array());
			}

			// print_r($link_data);

			$main_smarty = do_sidebar($main_smarty, $navwhere);
			$main_smarty->assign('posttitle', " / " . $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel'));

			$main_smarty->assign('tpl_center', akismet_tpl_path . 'manageSpam');
			$main_smarty->display($the_template . '/pligg.tpl');

		}

		if($view == 'manageSettings'){

			$main_smarty = do_sidebar($main_smarty, $navwhere);
			$main_smarty->assign('posttitle', " / " . $main_smarty->get_config_vars('PLIGG_Visual_Header_AdminPanel'));

			$main_smarty->assign('tpl_center', akismet_tpl_path . 'manageSettings');
			$main_smarty->display($the_template . '/pligg.tpl');

		}

		if($view == 'isSpam'){
			if(isset($_REQUEST['link_id'])){$link_id = sanitize($_REQUEST['link_id'], 3);}else{$link_id='';}

			$spam_links = get_misc_data('spam_links');
			$spam_links = unserialize(get_misc_data('spam_links'));

			unset($spam_links[$link_id]);
			misc_data_update('spam_links', serialize($spam_links));

			$link = new Link;
			$link->id = $link_id;
			$link->read(FALSE);
			$link->status = 'discard';
			$link->store();

			header('Location: ' . URL_akismet . '&view=manageSpam');
		}

		if($view == 'isNotSpam'){
			if(isset($_REQUEST['link_id'])){$link_id = sanitize($_REQUEST['link_id'], 3);}else{$link_id='';}

			$spam_links = get_misc_data('spam_links');
			$spam_links = unserialize(get_misc_data('spam_links'));

			unset($spam_links[$link_id]);
			misc_data_update('spam_links', serialize($spam_links));

			$link = new Link;
			$link->id = $link_id;
			$link->read(FALSE);
			$link->status = 'queued';
			$link->store();

			header('Location: ' . URL_akismet . '&view=manageSpam');
		}

		if($view == 'addSpam'){

			$spam_links[1] = 1;
			misc_data_update('spam_links', serialize($spam_links));
			header('Location: ' . URL_akismet . '&view=manageSpam');

		}
	}
}
?>
